<?php
class Contagem extends TRecord
{
    const TABLENAME = 'cliente';
    const PRIMARYKEY= 'id';
    const IDPOLICY =  'max'; // {max, serial}

    use SystemChangeLogTrait;

    public function __construct($id = NULL)
    {
        parent::__construct($id);
        parent::addAttribute('id_maquina');
        parent::addAttribute('e_anterior');
        parent::addAttribute('s_anterior');
        parent::addAttribute('e_atual');
        parent::addAttribute('s_atual');
        parent::addAttribute('bruto');
        parent::addAttribute('estabelecimento');
        parent::addAttribute('cobrador');
        parent::addAttribute('operador');
        parent::addAttribute('gerente');
    }

    public function get_nome_jogo()
    {
        return (new Maquina($this->id_maquina))->get_nome_jogo();
    }

    public function get_nome_zona()
    {
        return (new Zona($this->id_zona))->descricao;
    }
}
?>