<?php

use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Database\TTransaction;
use Adianti\Widget\Container\TVBox;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Wrapper\TDBCombo;

class PontoForm extends TPage
{
    protected $form; // form
    protected $program_list;

    /**
     * Class constructor
     * Creates the page and the registration form
     */
    function __construct()
    {
        parent::__construct();

        // creates the form
        $this->form = new BootstrapFormBuilder('form_ponto');
        $this->form->setFormTitle( 'Pontos' );

        // create the form fields
        $id          = new TEntry('id');
        $name        = new TEntry('nome');
        $porc_ponto  = new TEntry('porc_ponto');
        $operador    = new TDBCombo('operador','permission','SystemUser','id','name');
        $caixa       = new TEntry('caixa');

        $btn = $this->form->addAction( _t('Save'), new TAction(array($this, 'onSave')), 'fa:floppy-o');
        $btn->class = 'btn btn-sm btn-primary';
        $this->form->addAction( _t('Clear'), new TAction(array($this, 'onEdit')), 'fa:eraser red');
        $this->form->addAction( _t('Back'), new TAction(array('PontoList','onReload')), 'fa:arrow-circle-o-left blue');

        // define the sizes
        $id->setSize('50%');
        $name->setSize('100%');
        $porc_ponto->setSize('100%');
        $operador->setSize('100%');
        $caixa->setSize('100%');

        // outros
        $id->setEditable(false);

        // validations
        $name->addValidation(_t('Name'), new TRequiredValidator);
        $porc_ponto->addValidation(_t('Name'), new TRequiredValidator);
        $operador->addValidation(_t('Name'), new TRequiredValidator);

        $this->form->addFields( [new TLabel('ID')], [$id] );
        $this->form->addFields( [new TLabel('Nome')], [$name]);
        $this->form->addFields( [new TLabel('Porcentagem')], [$porc_ponto]);
        $this->form->addFields( [new TLabel('Operador')], [$operador]);
        $this->form->addFields( [new TLabel('Caixa')], [$caixa]);

        $container = new TVBox;
        $container->style = 'width: 90%';
        $container->add(new TXMLBreadCrumb('menu.xml', 'PontoList'));
        $container->add($this->form);

        // add the container to the page
        parent::add($container);
    }

    /**
     * method onSave()
     * Executed whenever the user clicks at the save button
     */
    public static function onSave($param)
    {
        try
        {
            // open a transaction with database 'permission'
            TTransaction::open('jackpot');
            $object = new Ponto;
            $object->fromArray( $param );
            $object->caixa = strtr($param['caixa'], ',', '.');
            $object->store();

//            $data = new stdClass;
//            $data->id = $object->id;
//            TForm::sendData('form_Ponto', $data);

            // close the transaction
            TTransaction::close();

            // shows the success message
            new TMessage('info', TAdiantiCoreTranslator::translate('Record saved'));

            TApplication::loadPage('PontoList','onReload');

        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * method onEdit()
     * Executed whenever the user clicks at the edit button da datagrid
     */
    function onEdit($param)
    {
        try
        {
            if (isset($param['key']))
            {
                TEntry::disableField('form_ponto', 'caixa');

                // get the parameter $key
                $key=$param['key'];

                // open a transaction with database 'permission'
                TTransaction::open('jackpot');

                // instantiates object System_user
                $object = new Ponto($key);
                $object->caixa = number_format( $object->caixa, 2, ',', '.');
                // fill the form with the active record data
                $this->form->setData($object);

                // close the transaction
                TTransaction::close();

            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }
}
