<?php
/**
 * CommonPage
 *
 * @version    7.6
 * @package    control
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class Utils extends TPage
{
    public function __construct()
    {
        parent::__construct();
        parent::add(new TLabel('Funcoes'));
    }
    /**
     * Formata Valores Monetários Caixa
     */
    public static function formatValueCx($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
//        if($object->maquinas =='TOTAL DE ENTRADAS'){$row->style = "background: #00BFFF";}
//        if($object->maquinas =='TOTAL DE PAGAMENTOS'){$row->style = "background: #FF3030";}
        $row->style = "background: #C1CDC1";
        if($object->maquinas =='SALDO'){$row->style = "background: #90EE90";}
        if($object->maquinas =='TOTAL'){$row->style = "background: #90EE90";}
        if($object->maquinas =='RETIRADAS'){$row->style = "background: #90EE90";}

        if(sprintf("%.2f", $stock) == '-0.00' or sprintf("%.2f", $stock) == '0.00'){
            return "<span style='color:blue'>$number</span>";
        }elseif ($stock < 0){
            return "<span style='color:red'>$number</span>";
        }else{
            return "<span style='color:blue'>$number</span>";
        }
    }
    /**
     * Formata Valores Monetários Movimento
     */
    public static function formatValueMov($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        if(sprintf("%.2f", $stock) == '-0.00' or sprintf("%.2f", $stock) == '0.00'){
            if($object->descricao =='DIFERENÇA #'){$row->style = "background: #FF0000";}else{$row->style = "background: #FFF9A7";}
            return "<span style='color:blue'>$number</span>";
        }elseif ($stock < 0){
            if($object->descricao =='DIFERENÇA #'){$row->style = "background: #32CD32";}
            return "<span style='color:red'>$number</span>";
        }else{
            if($object->descricao =='DIFERENÇA #'){$row->style = "background: #FF0000";}else{$row->style = "background: #FFF9A7";}
            return "<span style='color:blue'>$number</span>";
        }
    }

    /**
     * Format saldo
     */
    public static function formatValueLei($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        if ($stock < 0)
        {
            if($object->tipo =='GERAL'){$row->style = "background: #90EE90";}
            if($object->tipo =='TOTAIS'){$row->style = "background: #00BFFF";}
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            if($object->tipo =='GERAL'){$row->style = "background: #90EE90";}
            elseif($object->tipo =='TOTAIS'){$row->style = "background: #00BFFF";}
            else{$row->style = "background: #FFF9A7";}
            return "<span style='color:blue'>$number</span>";
        }
    }
}
