<?php
class EscolheSemana extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->tipo = $param['tipo'];

        TTransaction::open('bingo');
        $semana = config::getConfig('semana');
        TTransaction::close();

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        TTransaction::open('bingo');
        $repository = new TRepository('fecha');
        $criteria = new TCriteria();
        $criteria->add(new TFilter("DATE_FORMAT(dia,'%w')", '=', $semana));         // create the form fields
        $criteria->setProperty('order', 'dia asc');
        $reads = $repository->load($criteria);
        TTransaction::close();

        $diant = '';
        foreach ($reads as $key=>$read){
            if(TDate::date2br($read->dia) == $diant){unset($reads[$key]);}
            $diant = TDate::date2br($read->dia);
        }

        $dias = array();
        arsort($reads);
        foreach ($reads as $read){
            $dias[$read->id] = $read->dia;
            $dias[$read->id] = TDate::date2br($read->dia);
        }

        $dia_view = new TCombo('combo');
        $dia_view->addItems($dias);
        $acao = new TAction(array($this, 'onExitDia'));
        $acao->setParameter('tipo',$this->tipo);
        $dia_view->setChangeAction($acao);

        // add validators
        $dia_view->addValidation('Dia', new TRequiredValidator);

        // define some attributes
        $dia_view->style = 'font-size: 17pt; height: 30px; text-align: center;';

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        if($this->tipo == 'Caixa' ) {
            $cell = $row->addCell(new TLabel('CAIXA DA SEMANA A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Fecha' ){
            $cell = $row->addCell( new TLabel('FECHAMENTO DA SEMANA A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Leitura' ) {
            $cell = $row->addCell(new TLabel('LEITURA DA SEMANA A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Fabricante' ) {
            $cell = $row->addCell(new TLabel('SEMANA DO FABRICANTE A VISUALIZAR'))->style = 'text-align: center;';
        }

        // create the field labels
        $lab_cli = new TLabel('DIA INICIAL DA SEMANA');
        $lab_cli->setFontSize(17);
        $lab_cli->setFontFace('Trebuchet MS');

        $table_item->addRowSet($lab_cli)->style = 'text-align: center;';
        $table_item->addRowSet($dia_view)->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($dia_view));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item);
        parent::add($vbox);
    }

    public static function onExitDia($param)
    {
        TTransaction::open('bingo');
        $fecha = new fecha($param['key']);
        $dia = $fecha->dia;
        // close the transaction
        TTransaction::close();

        $dates = array();
        $dates['tipo'] = 'Semana';
        $dates['primeirodia'] = $dia;
        $dates['ultimodia'] = date('Y-m-d', strtotime("+6 days",strtotime($dia))).' 23:59:59';

        // reload the listing
        if($param['tipo'] == 'Caixa' ) {
            TApplication::gotoPage('CaixaList',NULL, $dates);
        }elseif($param['tipo'] == 'Leitura' ) {
            TApplication::gotoPage('LeituraSemList',NULL, $dates);
        }elseif($param['tipo'] == 'Fecha' ) {
            TApplication::gotoPage('FechaSemList',NULL, $dates);
        }elseif($param['tipo'] == 'Fabricante' ) {
            TApplication::gotoPage('FabricanteSemList',$dia);
        }
    }
}
