<?php
/**
 * StandardFormDataGridView
 *
 * @version    1.0
 * @package    samples
 * @subpackage tutor
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006-2014 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    http://www.adianti.com.br/framework-license
 */
class GeralList extends TStandardFormList
{
    protected $form;      // formulário de cadastro
    protected $datagrid;  // listagem
    protected $loaded;
    protected $pageNavigation;  // pagination component

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();

        // define the database
        parent::setDatabase('jackpot');

        // define the Active Record
        parent::setActiveRecord('Geral');

        // define the default order
        parent::setDefaultOrder('id', 'asc');

        // turn off limit for datagrid
        $this->setLimit(-1);

        // create the form
        $this->form = new TQuickForm('form_categories');
        $this->form->class = 'tform'; // CSS class
        $this->form->setFormTitle('Cadastro de Gerais');

        // create the form fields
        $id     = new TEntry('id');
        $name   = new TEntry('name');

        $name->addValidation(_t('Name'), new TRequiredValidator);

        // add the form fields
        $this->form->addQuickField('ID',    $id,    40);
        $this->form->addQuickField('Nome',  $name, 200);

        // define the form actions
        $this->form->addQuickAction(_t('Save'), new TAction(array($this, 'onSave')), 'ico_save.png');
        $this->form->addQuickAction(_t('New'),  new TAction(array($this, 'onClear')), 'ico_new.png');

        // make id not editable
        $id->setEditable(FALSE);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        // add the columns
        $this->datagrid->addQuickColumn('ID',   'id',  'center', 50, new TAction(array($this, 'onReload')), array('order', 'id'));
        $this->datagrid->addQuickColumn('Nome', 'name','left',  400, new TAction(array($this, 'onReload')), array('order', 'name'));

        // add the actions
        $this->datagrid->addQuickAction('Edit',  new TDataGridAction(array($this, 'onEdit')),   'id', 'ico_edit.png');
        $this->datagrid->addQuickAction('Delete', new TDataGridAction(array($this, 'onDelete')), 'id', 'ico_delete.png');

        // create the datagrid model
        $this->datagrid->createModel();

        // wrap objects inside a table
        $vbox = new TVBox;
        $vbox->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $vbox->add($this->form);
        $vbox->add($this->datagrid);
        // pack the table inside the page
        parent::add($vbox);
    }
}