<?php

class MoviDiaList extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        $this->labelTotal = new TLabel(' ');
        $this->labelTotal->setFontSize(17);
        $this->labelTotal->setFontFace('Trebuchet MS');
        $this->labelTotal->setFontColor('white');

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';

        // add the columns
        $this->datagrid->addQuickColumn('Data','dia','center', "25%", new TAction(array($this, 'onReload')), array('order', 'dia'));
        $this->datagrid->addQuickColumn('Usuário','usuario','center', "17%", new TAction(array($this, 'onReload')), array('order', 'usuario'));
        $this->datagrid->addQuickColumn('Máquina','maquina','center', "8%", new TAction(array($this, 'onReload')), array('order', 'maquina'));
        $this->datagrid->addQuickColumn('Descrição','descricao','left', "25%", new TAction(array($this, 'onReload')), array('order', 'descricao'));
        $valor = $this->datagrid->addQuickColumn('Valor', 'valor', 'right', "25%", new TAction(array($this, 'onReload')), array('order', 'valor'));
        $valor->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid->setGroupColumn('maquina', '<b>Máquina</b>: <strong>{maquina}</strong>');
        $this->datagrid->createModel();
        $this->onReload();

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->datagrid)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        parent::add($vbox);
    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload($param = NULL)
    {
        try
        {
            $this->totalgeral = 0;

            TTransaction::open('bingo');
            $repository = new TRepository('SystemUser');
            $users = $repository->load();
            $cod_users=array();
            $cod_users[0] = array('SISTEMA',0);
            foreach ($users as $user){
                $cod_users[$user->id] = array($user->name, 0);
            }

            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $newparam = $param; // define new parameters
            $criteria->setProperty('order', 'maquina asc, dia asc');
            $criteria->setProperties($newparam); // order, offset
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $criteria->add(new TFilter('maquina', '>', 101));
            $criteria->add(new TFilter('maquina', '<', 500));
            $customers = $repository->load($criteria, FALSE);

            $this->datagrid->clear();

            $machine='0';
            $total_machine=0;

            if ($customers)
            {
                foreach ($customers as $customer)
                {
                                        if($machine != $customer->maquina AND $machine != '0'){
                                            $obj = new stdclass();
                                            $obj->id = '';
                                            $obj->dia = '';
                                            $obj->usuario = '';
                                            $obj->maquina = $machine;
                                            $obj->valor = $total_machine;
                                            $obj->descricao = 'TOTAL';
                                            $this->datagrid->addItem($obj);

                                            $total_machine = 0;

                                        };
                                        $total_machine += $customer->valor * -1;
                                        $machine = $customer->maquina;
                    $customer->dia = substr($customer->dia,8,2).'/'.substr($customer->dia,5,2).'/'.substr($customer->dia,0,4).' - '.substr($customer->dia,11,2).':'.substr($customer->dia,14,2).':'.substr($customer->dia,17,2);

                    $cod_users[$customer->usuario][1] += $customer->valor;

                    $this->totalgeral += $customer->valor;

                    if($customer->maquina > 0){

                        $quem = new SystemUser($customer->usuario);
                        $customer->usuario = $quem->login;
                        // add the object inside the datagrid
                        $this->datagrid->addItem($customer);
                    }
                }
                $obj = new stdclass();
                $obj->id = '';
                $obj->dia = '';
                $obj->usuario = '';
                $obj->maquina = $machine;
                $obj->valor = $total_machine;
                $obj->descricao = 'TOTAL';
                $this->datagrid->addItem($obj);

            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        if ($stock < 0)
        {
            if($object->descricao =='DIFERENÇA #'){$row->style = "background: #00BFFF";}
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            if($object->descricao =='DIFERENÇA #'){$row->style = "background: #00BFFF";}else{$row->style = "background: #FFF9A7";}
            return "<span style='color:blue'>$number</span>";
        }
    }

}