<?php

class LeituraSemList extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $ini = parse_ini_file('app/config/application.ini', true);

        $primeirodia = $param["method"];
        $ultimodia = date('Y-m-d', strtotime("+6 days",strtotime($primeirodia))).' 23:59:59';
        $porc_cartao = $this->ini['general']['txcard'];

        TTransaction::open('bingo');

        // Recupera Contadores
        $repository = new TRepository('leitura');
        $criteria = new TCriteria;
        $criteria->setProperty('order', 'maquina asc, fechado asc');
        $criteria->add(new TFilter('fechado', '>=', $primeirodia));
        $criteria->add(new TFilter('fechado', '<=', $ultimodia));
        $leituras = $repository->load($criteria);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';

        // add the columns
        $this->datagrid->addQuickColumn('Máquina','maquina','center', 50);
        $this->datagrid->addQuickColumn('Tipo','tipo','center', 100);
        $this->datagrid->addQuickColumn('Entrada Inicial','ini_entra','center');
        $this->datagrid->addQuickColumn('Saída Inicial','ini_sai','center');
        $this->datagrid->addQuickColumn('Entrada Final','fim_entra','center');
        $this->datagrid->addQuickColumn('Saída Final','fim_sai','center');
        $jogou = $this->datagrid->addQuickColumn('Jogou', 'jogou', 'right', 100);
        $jogou->setTransformer(array($this, 'formatsaldo'));
        $pagou = $this->datagrid->addQuickColumn('Pagou', 'pagou', 'right');
        $pagou->setTransformer(array($this, 'formatsaldo'));
        $azul = $this->datagrid->addQuickColumn('L/P', 'azul', 'right');
        $azul->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid->addQuickColumn('Retenção', 'retencao', 'center');

        // create the datagrid model
        $this->datagrid->createModel();

        $quebra='0';
        $ent_fim_ilha = 0;
        $ent_ini_ilha = 0;
        $jogou_ilha=0;
        $sai_fim_ilha = 0;
        $sai_ini_ilha = 0;
        $pagou_ilha=0;
        $azul_ilha=0;

        $ent_fim_geral = 0;
        $ent_ini_geral = 0;
        $jogou_geral=0;
        $sai_fim_geral = 0;
        $sai_ini_geral = 0;
        $pagou_geral=0;
        $azul_geral=0;
        $quebra_machine=0;
        $ordem=0;
        if ($leituras)
        {
            foreach ($leituras as $leitura)
            {
                if($quebra_machine == 0){
                    $ordem = 1;
                    $quebra_machine = $leitura->maquina;
                }elseif($quebra_machine != $leitura->maquina){
                    $ordem = 1;
                    $this->datagrid->addItem($obj);
                    $quebra_machine = $leitura->maquina;
                }
                if($ordem == 1){
                    $machine = new maquina($leitura->maquina);
                    $obj = new stdclass();
                    $obj->ilha = $machine->ilha;
                    $obj->maquina = $leitura->maquina;
                    $obj->tipo = $machine->tipo;
                    $obj->fim_entra = $leitura->fim_entra;
                    $obj->ini_entra = $leitura->ini_entra;
                    $obj->jogou = ($obj->fim_entra-$obj->ini_entra)*$leitura->credito;
                    $obj->fim_sai = $leitura->fim_sai;
                    $obj->ini_sai = $leitura->ini_sai;
                    $obj->pagou = ($obj->fim_sai-$obj->ini_sai)*$leitura->credito;
                    $obj->azul = $obj->jogou - $obj->pagou;
                    if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
                    elseif($obj->pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
                    $obj->retencao = $retencao;
                    $ordem++;
                } else {
                    $obj->fim_entra = $leitura->fim_entra;
                    $obj->jogou += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                    $obj->fim_sai = $leitura->fim_sai;
                    $obj->pagou += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                    $obj->azul = $obj->jogou - $obj->pagou;
                    if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
                    elseif($obj->pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
                    $obj->retencao = $retencao;
                }

                if($quebra == '0'){$quebra = $machine->ilha;}

                if($quebra != $machine->ilha){
                    $obj1 = new stdclass();
                    $obj1->ilha = $machine->ilha;
                    $obj1->maquina = '';
                    $obj1->tipo = 'TOTAIS';
                    $obj1->fim_entra = $ent_fim_ilha;
                    $obj1->ini_entra = $ent_ini_ilha;
                    $obj1->jogou = $jogou_ilha;
                    $obj1->fim_sai = $sai_fim_ilha;
                    $obj1->ini_sai = $sai_ini_ilha;
                    $obj1->pagou = $pagou_ilha;
                    $obj1->azul = $azul_ilha;
                    if($obj1->pagou == 0 AND $obj1->jogou == 0){$retencao = '';}
                    elseif($obj1->pagou == 0){$retencao = '100,00';}
                    else{$retencao = number_format(100-((($obj1->fim_sai-$obj1->ini_sai) / ($obj1->fim_entra-$obj1->ini_entra))*100), 2, ',', '.');}
                    $obj1->retencao = $retencao;
                    $this->datagrid->addItem($obj1);
                    $ent_fim_ilha = 0;
                    $ent_ini_ilha = 0;
                    $jogou_ilha=0;
                    $sai_fim_ilha = 0;
                    $sai_ini_ilha = 0;
                    $pagou_ilha=0;
                    $azul_ilha=0;
                    $quebra = $machine->ilha;
                };

                $ent_fim_ilha += $leitura->fim_entra;
                $ent_ini_ilha += $leitura->ini_entra;
                $jogou_ilha += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                $sai_fim_ilha += $leitura->fim_sai;
                $sai_ini_ilha += $leitura->ini_sai;
                $pagou_ilha += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                $azul_ilha += (($leitura->fim_entra-$leitura->ini_entra) - ($leitura->fim_sai-$leitura->ini_sai))*$leitura->credito;

                $ent_fim_geral += $leitura->fim_entra;
                $ent_ini_geral += $leitura->ini_entra;
                $jogou_geral += ($leitura->fim_entra-$leitura->ini_entra)*$leitura->credito;
                $sai_fim_geral += $leitura->fim_sai;
                $sai_ini_geral += $leitura->ini_sai;
                $pagou_geral += ($leitura->fim_sai-$leitura->ini_sai)*$leitura->credito;
                $azul_geral += (($leitura->fim_entra-$leitura->ini_entra) - ($leitura->fim_sai-$leitura->ini_sai))*$leitura->credito;



            }
            $this->datagrid->addItem($obj);
            $obj = new stdclass();
            $obj->ilha = $machine->ilha;
            $obj->maquina = '';
            $obj->tipo = 'TOTAIS';
            $obj->fim_entra = $ent_fim_ilha;
            $obj->ini_entra = $ent_ini_ilha;
            $obj->jogou = $jogou_ilha;
            $obj->fim_sai = $sai_fim_ilha;
            $obj->ini_sai = $sai_ini_ilha;
            $obj->pagou = $pagou_ilha;
            $obj->azul = $azul_ilha;
            if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
            elseif($obj->pagou == 0){$retencao = '100,00';}
            else{$retencao = number_format(100-((($obj->fim_sai-$obj->ini_sai) / ($obj->fim_entra-$obj->ini_entra))*100), 2, ',', '.');}
            $obj->retencao = $retencao;
            $this->datagrid->addItem($obj);

            $obj = new stdclass();
            $obj->ilha = $machine->ilha;
            $obj->maquina = '';
            $obj->tipo = 'GERAL';
            $obj->fim_entra = $ent_fim_geral;
            $obj->ini_entra = $ent_ini_geral;
            $obj->jogou = $jogou_geral;
            $obj->fim_sai = $sai_fim_geral;
            $obj->ini_sai = $sai_ini_geral;
            $obj->pagou = $pagou_geral;
            $obj->azul = $azul_geral;
            if($obj->pagou == 0 AND $obj->jogou == 0){$retencao = '';}
            elseif($obj->pagou == 0){$retencao = '100,00';}
            else{$retencao = number_format((($azul_geral / $jogou_geral)*100), 2, ',', '.');}
            $obj->retencao = $retencao;
            $this->datagrid->addItem($obj);
        }

        // reset the criteria for record count
        $criteria->resetProperties();
        $count= $repository->count($criteria);

        // close the transaction
        TTransaction::close();

        $this->frame = new TFrame;
        $lab_cxdia = new TLabel('dia');
        $lab_cxdia->setFontSize(17);
        $lab_cxdia->setFontFace('Trebuchet MS');
        $lab_cxdia->setValue('LEITURAS - ');
        $this->frame->add($lab_cxdia);

        $lab_dia = new TLabel('dia');
        $lab_dia->setFontSize(17);
        $lab_dia->setFontFace('Trebuchet MS');
        $form_dia = substr($primeirodia,8,2).'/'.substr($ultimodia,5,2).'/'.substr($ultimodia,0,4)." A ".substr($ultimodia,8,2).'/'.substr($ultimodia,5,2).'/'.substr($ultimodia,0,4);
        $lab_dia->setValue($form_dia);
        $this->frame->add($lab_dia);

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->form_item);
        $vbox->add($this->frame)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid)->style = 'width: 100%; text-align: center;overflow-x:auto;';

        parent::add($vbox);
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        if ($stock < 0)
        {
            if($object->tipo =='GERAL'){$row->style = "background: #90EE90";}
            if($object->tipo =='TOTAIS'){$row->style = "background: #00BFFF";}
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            if($object->tipo =='GERAL'){$row->style = "background: #90EE90";}
            elseif($object->tipo =='TOTAIS'){$row->style = "background: #00BFFF";}
            else{$row->style = "background: #FFF9A7";}
            return "<span style='color:blue'>$number</span>";
        }
    }
}