<?php

class LeituraFecList extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->primeirodia = $param["method"];

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        // create the datagrid
        $this->datagrid = new TQuickGrid;
        $this->datagrid->style = 'width: 100%';

        // add the columns
        $this->datagrid->addQuickColumn('Partida','partida','center', "3%", new TAction(array($this, 'onReload')), array('order', 'partida'));
        $this->datagrid->addQuickColumn('Inicial','inicial','center', "7%", new TAction(array($this, 'onReload')), array('order', 'inicial'));
        $this->datagrid->addQuickColumn('Final','final','center', "7%", new TAction(array($this, 'onReload')), array('order', 'final'));
        $this->datagrid->addQuickColumn('Cortesia','cortesia','center', "5%", new TAction(array($this, 'onReload')), array('order', 'cortesia'));
        $this->datagrid->addQuickColumn('Vendidos','qtde','center', "7%", new TAction(array($this, 'onReload')), array('order', 'qtde'));
        $coluna = $this->datagrid->addQuickColumn('P.Série','valor','center', "7%", new TAction(array($this, 'onReload')), array('order', 'valor'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Arrecadado','arrecadado','center', "8%", new TAction(array($this, 'onReload')), array('order', 'arrecadado'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Linha','linha','center', "8%", new TAction(array($this, 'onReload')), array('order', 'linha'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Bingo','bingo','center', "8%", new TAction(array($this, 'onReload')), array('order', 'bingo'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('2º Bingo','bingo2','center', "8%", new TAction(array($this, 'onReload')), array('order', 'bingo2'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Extra','extra','center', "8%", new TAction(array($this, 'onReload')), array('order', 'extra'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Total Prêmios','premios','center', "8%", new TAction(array($this, 'onReload')), array('order', 'premios'));
        $coluna->setTransformer(array($this, 'formatSaldox'));
        $coluna = $this->datagrid->addQuickColumn('Lucro','lucro','center', "8%", new TAction(array($this, 'onReload')), array('order', 'lucro'));
        $coluna->setTransformer(array($this, 'formatSaldo'));
        $coluna = $this->datagrid->addQuickColumn('Saldo','saldo','center', "8%", new TAction(array($this, 'onReload')), array('order', 'saldo'));
        $coluna->setTransformer(array($this, 'formatSaldo'));

//        $this->datagrid->setGroupColumn('ilha', '{ilha}');
        // create the datagrid model
        $this->datagrid->createModel();

        $this->frame = new TFrame;

        $this->onReload();

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->frame)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        parent::add($vbox);
    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload($param = NULL)
    {
        try
        {
            {
                TTransaction::open('bingo');
                $repository = new TRepository('leitura');
                $criteria = new TCriteria;
                $newparam = $param; // define new parameters
                // default order
                if (empty($newparam['order']))
                {
                    $newparam['order'] = 'partida';
                    $newparam['direction'] = 'asc';
                }

                $criteria->setProperties($newparam); // order, offset
                $criteria->add(new TFilter('fechado', '=', $this->primeirodia));
                $customers = $repository->load($criteria, FALSE);
                $this->datagrid->clear();

                $saldo=0;
                if ($customers)
                {
                    foreach ($customers as $customer)
                    {
                        $customer->arrecadado = $customer->valor * ($customer->qtde/6);
                        $customer->premios = $customer->linha + $customer->bingo + $customer->bingo2+ $customer->extra;
                        $customer->lucro = $customer->arrecadado - $customer->premios;
                        $customer->saldo = $saldo + $customer->lucro;
                        $saldo = $customer->saldo;
                        $this->datagrid->addItem($customer);
                    }
                }

                // reset the criteria for record count
                $criteria->resetProperties();
                $count= $repository->count($criteria);
                TTransaction::close();

                // close the transaction
                $this->loaded = true;
            }
            $lab_cxdia = new TLabel('dia');
            $lab_cxdia->setFontSize(17);
            $lab_cxdia->setFontFace('Trebuchet MS');
            $lab_cxdia->setValue('PARTIDAS DO DIA - ');
            $this->frame->add($lab_cxdia);

            $lab_dia = new TLabel('dia');
            $lab_dia->setFontSize(17);
            $lab_dia->setFontFace('Trebuchet MS');
            $form_dia = substr($this->primeirodia,8,2).'/'.substr($this->primeirodia,5,2).'/'.substr($this->primeirodia,0,4);
            $lab_dia->setValue($form_dia);
            $this->frame->add($lab_dia);
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
        if ($stock < 0)
        {
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            return "<span style='color:blue'>$number</span>";
        }
    }

    public function formatSaldox($stock, $object, $row)
    {
        $number = number_format($stock, 2, ',', '.');
        if ($stock > 499)
        {
            $row->style = "background: #FF6A6A";
            return "<span style='color:blue'>$number</span>";
        }
        else
        {
            $row->style = "background: #FFF9A7";
            return "<span style='color:blue'>$number</span>";
        }
    }

    /**
     * Exit action for the field product
     * Fill some form fields (sale_price, amount, discount, total)
     */
    public static function onExitDia($param)
    {

        TSession::setValue('dia_visu',$param['key']);
        // reload the listing
        TApplication::loadPage('LeituraFecList', 'onReload');
    }

}