<?php

class LeituraConfere extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        $this->ini  = AdiantiApplicationConfig::get();

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        $maquina_id = new TDBCombo('maquina_id','bingo','maquina','id','id','id');
        $maquina_id->setChangeAction(new TAction(array($this, 'onExitMaquina')));

        $entant  = new TEntry('entant');
        $saiant  = new TEntry('saiant');
        $registro = new THidden('registro');

        $entant->setEditable(FALSE);
        $saiant->setEditable(FALSE);

        $entant->setSize(200);
        $saiant->setSize(200);

        // add validators
        $maquina_id->addValidation('Máquina', new TRequiredValidator);

        // define some attributes
        $maquina_id->style = 'font-size: 28pt; height: 60px;text-align: center;';
        $entant->style = 'font-size: 28pt; height: 60px; text-align: center; background-color: #00ffff; ';
        $saiant->style = 'font-size: 28pt; height: 60px; text-align: center; background-color: #00ffff; ';

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        $row->addCell( new TLabel('CONFERÊNCIA DE LEITURA DO DIA'))->style = 'text-align: center; width:100%;';

        // create the field labels
        $lab_maq = new TLabel('MÁQUINA');
        $lab_maq->setFontSize(17);
        $lab_maq->setFontFace('Trebuchet MS');
        $lab_maq->setFontColor('blue');

        $lab_enta = new TLabel('ENTRADA ATUAL');
        $lab_enta->setFontSize(17);
        $lab_enta->setFontFace('Trebuchet MS');
        $lab_enta->setFontColor('blue');

        $lab_saia = new TLabel('SAIDA ATUAL');
        $lab_saia->setFontSize(17);
        $lab_saia->setFontFace('Trebuchet MS');
        $lab_saia->setFontColor('blue');

        // creates the action button
        $button1 = new TButton('tras');
        $button1->setAction(new TAction(array($this, 'onTras')), '<< ANTERIOR');
        $button1->class = 'btn btn-success btn-lg btn-block';

        $button2 = new TButton('frente');
        $button2->setAction(new TAction(array($this, 'onFrente')), ' PRÓXIMA>>');
        $button2->class = 'btn btn-success btn-lg btn-block';

        // add the form fields
        $table_item->addRowSet($lab_maq)->style = 'text-align: center;';
        $table_item->addRowSet($maquina_id)->style = 'text-align: center;';
        $table_item->addRowSet($lab_enta)->style = 'text-align: center;';
        $table_item->addRowSet($entant)->style = 'text-align: center;';
        $table_item->addRowSet($lab_saia)->style = 'text-align: center;';
        $table_item->addRowSet($saiant)->style = 'text-align: center;';
        $table_item->addRowSet('');
        $table_item->addRowSet(array($button1, $button2))->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($maquina_id, $registro, $entant, $saiant, $button1, $button2));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item)->style = 'width: 100%; text-align: center;';
        parent::add($vbox);
    }

    public function onTras()
    {
        try
        {
            $this->form_item->validate(); // validate form data
            $data = $this->form_item->getData();
            if($data->maquina_id == 1){
                $obj = new StdClass;
                $obj->maquina_id = $this->ini['general']['equips'];
            } else {
                $obj = new StdClass;
                $obj->maquina_id = $data->maquina_id - 1;
            }
            TForm::sendData('form_atendente', $obj);
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onFrente()
    {
        try
        {
            $this->form_item->validate(); // validate form data
            $data = $this->form_item->getData();
            if($data->maquina_id == $this->ini['general']['equips']){
                $obj = new StdClass;
                $obj->maquina_id = 1;
            } else {
                $obj = new StdClass;
                $obj->maquina_id = $data->maquina_id + 1;
            }
            TForm::sendData('form_atendente', $obj);
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    /**
     * Exit action for the field product
     * Fill some form fields (sale_price, amount, discount, total)
     */
    public static function onExitMaquina($param)
    {
        $codigo = $param['maquina_id']; // get the product code
        try
        {
            TTransaction::open('bingo');
            $criteria = new TCriteria();
            $criteria->add(new TFilter('maquina', '=', $codigo));
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $repository = new TRepository('leitura');
            $machine = $repository->load($criteria);
            $item = $machine[0];
            $leitura = new leitura($item->id);
            $registro = $item->id;
            $obj = new StdClass;
            $obj->entant   = $leitura->fim_entra;
            $obj->saiant   = $leitura->fim_sai;
            $obj->registro = $registro;
            $obj->moeda = $item->credito;
            TTransaction::close();
            TForm::sendData('form_atendente', $obj);
        }
        catch (Exception $e)
        {
            // does nothing
        }
    }

    public function onEdit($param)
    {
        try
        {
            // open a transaction with database
            TTransaction::open('bingo');

            $leitura = new leitura($param['key']);
            $obj = new StdClass;
            $obj->maquina_id = $leitura->maquina;
            TTransaction::close();
            TForm::sendData('form_atendente', $obj);

            return $leitura;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

}