<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Database\TTransaction;
use Adianti\Registry\TSession;
use Adianti\Validator\TRequiredValidator;
use Adianti\Widget\Container\TTable;
use Adianti\Widget\Container\TVBox;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TButton;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TForm;
use Adianti\Widget\Form\TLabel;
use Adianti\Widget\Form\THidden;
use Adianti\Widget\Wrapper\TDBCombo;

class LeiInicialForm extends TPage
{
    public function __construct()
    {
        parent::__construct();
        new TSession;

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        $maquina_id = new TDBCombo('cod_cliente','bingo','maquina','id','id','id');
        $maquina_id->setChangeAction(new TAction(array($this, 'onExitCliente')));


//        $maquina_id = new TEntry('maquina_id');
        $entrada = new TEntry('entrada');
        $saida   = new TEntry('saida');
        $entant  = new TEntry('entant');
        $saiant  = new TEntry('saiant');
        $registro  = new THidden('registro');

        $entant->setEditable(FALSE);
        $saiant->setEditable(FALSE);

        $entrada->autocomplete = 'off';
        $saida->autocomplete = 'off';

        // add validators
        $maquina_id->addValidation('Máquina', new TRequiredValidator);

        // define some attributes
        $maquina_id->style = 'font-size: 17pt; height: 30px;text-align: center;';
        $entrada->style = 'font-size: 17pt; height: 30px; text-align: center;';
        $entant->style = 'font-size: 17pt; height: 30px; text-align: center; background-color: #ffff99; ';
        $saida->style = 'font-size: 17pt; height: 30px; text-align: center;';
        $saiant->style = 'font-size: 17pt; height: 30px; text-align: center; background-color: #ffff99; ';

        $entrada->setInputType('number');
        $saida->setInputType('number');

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        $row->addCell( new TLabel('LEITURA INICIAL DO DIA'))->style = 'text-align: center; width:100%;';

        // create the field labels
        $lab_maq = new TLabel('MÁQUINA');
        $lab_maq->setFontSize(17);
        $lab_maq->setFontFace('Trebuchet MS');

        $lab_enta = new TLabel('ENTRADA ANTERIOR');
        $lab_enta->setFontSize(17);
        $lab_enta->setFontFace('Trebuchet MS');
        $lab_enta->setFontColor('red');

        $lab_ent = new TLabel('ENTRADA ATUAL');
        $lab_ent->setFontSize(17);
        $lab_ent->setFontFace('Trebuchet MS');

        $lab_sai = new TLabel('SAIDA ATUAL');
        $lab_sai->setFontSize(17);
        $lab_sai->setFontFace('Trebuchet MS');

        $lab_saia = new TLabel('SAIDA ANTERIOR');
        $lab_saia->setFontSize(17);
        $lab_saia->setFontFace('Trebuchet MS');
        $lab_saia->setFontColor('red');

        // creates the action button
        $button1 = new TButton('add');
        $button1->setAction(new TAction(array($this, 'onSave')), 'SALVAR');
        $button1->class = 'btn btn-success btn-lg btn-block';

        // add the form fields
        $table_item->addRowSet($lab_maq)->style = 'text-align: center;';
        $table_item->addRowSet($maquina_id)->style = 'text-align: center;';
        $table_item->addRowSet($lab_enta)->style = 'text-align: center;';
        $table_item->addRowSet($entant)->style = 'text-align: center;';
        $table_item->addRowSet($lab_ent)->style = 'text-align: center;';
        $table_item->addRowSet($entrada)->style = 'text-align: center;';
        $table_item->addRowSet($lab_saia)->style = 'text-align: center;';
        $table_item->addRowSet($saiant)->style = 'text-align: center;';
        $table_item->addRowSet($lab_sai)->style = 'text-align: center;';
        $table_item->addRowSet($saida)->style = 'text-align: center;';
        $table_item->addRowSet($registro)->style = 'text-align: center;';
        $table_item->addRowSet('');
        $table_item->addRowSet(array($button1))->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($maquina_id, $entrada, $entant, $saida, $saiant, $registro, $button1));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add(new TXMLBreadCrumb('menu.xml', __CLASS__));
        $vbox->add($this->form_item);
        parent::add($vbox);
    }
    /**
     * Saves the cart
     */
    public function onSave()
    {
        try
        {
            $this->form_item->validate(); // validate form data
            $data = $this->form_item->getData();
            $alterada = 1;
            if($data->entrada == NULL AND $data->saida == NULL){$alterada=0;}
            if($data->entrada == NULL){$data->entrada = $data->entant;}
            if($data->saida == NULL){$data->saida = $data->saiant;}
            TTransaction::open('bingo');
            $leitura = new leitura($data->registro);
            $leitura->ini_entra = $data->entrada;
            $leitura->fim_entra = $data->entrada;
            $leitura->ini_sai = $data->saida;
            $leitura->fim_sai = $data->saida;
            $leitura->ok = 0;
            $leitura->store();
            $this->form_item->clear(); // clear form
            if($alterada){
                new TMessage('info', 'Leitura Salva com Sucesso');
            } else {
                new TMessage('warning', 'Leitura Inalterada');
            }

            $teste = new stdClass();
            $teste->cod_cliente = $data->cod_cliente;
            $this->form_item->setData($teste);

            TTransaction::close();
        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    /**
     * Exit action for the field product
     * Fill some form fields (sale_price, amount, discount, total)
     */
    public static function onExitCliente($param)
    {
        try
        {
            $codigo = $param['cod_cliente']; // get the product code
            TTransaction::open('bingo');
            $criteria = new TCriteria();
            $criteria->add(new TFilter('maquina', '=', $codigo));
            $criteria->add(new TFilter('fechado', 'IS', NULL));
            $repository = new TRepository('leitura');
            $machine = $repository->load($criteria);
            $item = $machine[0];
            $leitura = new leitura($item->id);
            $registro = $item->id;
            $obj = new StdClass;
            $obj->entant   = $leitura->fim_entra;
            $obj->saiant   = $leitura->fim_sai;
            $obj->registro = $registro;
            TTransaction::close();
            TForm::sendData('form_atendente', $obj);
        }
        catch (Exception $e)
        {
            // does nothing
        }
    }

}