<?php
class EscolheDia extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->tipo = $param['tipo'];
        $this->dias = array();

        // creates the items form and add a table inside
        $this->form_item = new TForm('form');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        TTransaction::open('bingo');
        $repository = new TRepository('fecha');
        $criteria = new TCriteria();
        $criteria->setProperty('order', 'dia desc');
        $reads = $repository->load($criteria);
        TTransaction::close();
        $dias = array();
        foreach ($reads as $read){
            $this->dias[$read->id] = $read->dia;
            $dias[$read->id] = TDate::date2br($read->dia);
        }
        $dia_view = new TCombo('combo');
        $dia_view->addItems($dias);
        $acao = new TAction(array($this, 'onExitDia'));
        $acao->setParameter('tipo',$this->tipo);
        $dia_view->setChangeAction($acao);

        // add validators
        $dia_view->addValidation('Dia', new TRequiredValidator);

        // define some attributes
        $dia_view->style = 'font-size: 17pt; height: 30px; text-align: center;';

        // add a row for the form title
        $row  = $table_item->addRow();
        $row->class = 'tformtitle'; // CSS class
        if($this->tipo == 'Lanca' ){
            $cell = $row->addCell( new TLabel('DESPESAS A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Paga' ) {
            $cell = $row->addCell(new TLabel('PAGAMENTOS A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Resumo' ) {
            $cell = $row->addCell(new TLabel('RESUMO A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Caixa' ) {
            $cell = $row->addCell(new TLabel('CAIXA A VISUALIZAR'))->style = 'text-align: center;';
        }elseif($this->tipo == 'Leitura' ) {
            $cell = $row->addCell(new TLabel('PARTIDAS A VISUALIZAR'))->style = 'text-align: center;';
        }

        // create the field labels
        $lab_cli = new TLabel('DIA');
        $lab_cli->setFontSize(17);
        $lab_cli->setFontFace('Trebuchet MS');

        $table_item->addRowSet($lab_cli)->style = 'text-align: center;';
        $table_item->addRowSet($dia_view)->style = 'text-align: center;';

        // define the form fields
        $this->form_item->setFields(array($dia_view));

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->form_item);
        parent::add($vbox);
    }

    public static function onExitDia($param)
    {
        TTransaction::open('bingo');
        $fecha = new fecha($param['key']);
        $dia = $fecha->dia;
        // close the transaction
        TTransaction::close();

        // reload the listing
        if($param['tipo'] == 'Lanca' ) {
            TApplication::loadPage('LancaFecList',$dia);
        }elseif($param['tipo'] == 'Paga' ) {
            TApplication::loadPage('PagaFecList',$dia);
        }elseif($param['tipo'] == 'Resumo' ) {
            TApplication::loadPage('ResuFecList',$dia);
        }elseif($param['tipo'] == 'Caixa' ) {
            TApplication::loadPage('CaixaFecList',$dia);
        }elseif($param['tipo'] == 'Leitura' ) {
            TApplication::loadPage('LeituraFecList',$dia);
        }
    }
}
