<?php

class CaixaFecList extends TPage
{
    public function __construct($param)
    {
        parent::__construct();
        new TSession;

        $this->primeirodia = $param["method"];

        // creates the items form and add a table inside
        $this->form_item = new TForm('form_atendente');
        $this->form_item->class = 'tform';
        $table_item = new TTable;
        $table_item-> width = '100%';
        $this->form_item->add($table_item);

        // create the datagrid - Contadores
        $this->datagrid0 = new TQuickGrid;
        $this->datagrid0->style = 'width: 100%';
        $this->datagrid0->addQuickColumn('FECHAMENTO'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid0->addQuickColumn('APURADO','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid0->createModel();

        // create the datagrid - Receitas
        $this->datagrid1 = new TQuickGrid;
        $this->datagrid1->style = 'width: 100%';
        $this->datagrid1->addQuickColumn('RECEITA'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid1->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid1->createModel();

        // create the datagrid - Entrega do caixa
        $this->datagrid2 = new TQuickGrid;
        $this->datagrid2->style = 'width: 100%';
        $this->datagrid2->addQuickColumn('CAIXA A ENTREGAR'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid2->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid2->createModel();

        // create the datagrid - Vales
        $this->datagrid3 = new TQuickGrid;
        $this->datagrid3->style = 'width: 100%';
        $this->datagrid3->addQuickColumn('VALES'  ,'maquinas'  ,'left', 150);
        $contadores = $this->datagrid3->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid3->createModel();

        // create the datagrid - Despesas
        $this->datagrid4 = new TQuickGrid;
        $this->datagrid4->style = 'width: 100%';
        $this->datagrid4->addQuickColumn('DESPESAS'  ,'maquinas'  ,'left', 150);

        $contadores = $this->datagrid4->addQuickColumn('VALOR','contadores','center', 150);
        $contadores->setTransformer(array($this, 'formatsaldo'));
        $this->datagrid4->createModel();

        // creates a frame
        $this->frame = new TFrame;
        $this->frame1 = new TFrame;

        // creates an action button
        $print_button = new TButton('ptinr');
        $print_button->setAction(new TAction(['CaixaFecPrint','onReload'], ['dia'=>$this->primeirodia]), 'IMPRIMIR FECHAMENTO');
        $print_button->class = 'btn btn-info';

        // define the form fields
        $this->form_item->setFields(array($print_button));

        $this->onReload();

        // wrap the page content using vertical box
        $vbox = new TVBox;
        $vbox->style = 'width: 100%; text-align: center;';
        $vbox->add($this->frame)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid0)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid2)->style = 'width: 100%; text-align: center;overflow-x:auto;';
//        $vbox->add($this->datagrid3)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        $vbox->add($this->datagrid4)->style = 'width: 100%; text-align: center;overflow-x:auto;';
        parent::add($vbox);
    }

    /**
     * method onReload()
     * Load the datagrid with the database objects
     */
    function onReload($param = NULL)
    {
        try
        {
            $ini = parse_ini_file('app/config/application.ini', true);

            TTransaction::open('bingo');

            // Recupera Contadores
            $repository = new TRepository('leitura');
            $criteria = new TCriteria;
            $criteria->add(new TFilter('fechado', '=', $this->primeirodia));
            $reads = $repository->load($criteria);
            $conta_entra = 0;
            $conta_saida = 0;
            $conta_card = array();
            $conta_ent = array();
            $conta_sai = array();
            $conta_cor[0] = 0;
            $conta_cor[1] = 0;
            for ($i = 0; $i <= 100; $i++) {
                $conta_card[] = 0;
                $conta_ent[] = 0;
                $conta_sai[] = 0;
            }
            $conta_linha = 0;
            $conta_bingo = 0;
            $conta_bingo2 = 0;
            $conta_extra = 0;
            foreach ($reads as $read){
                $conta_card[$read->valor] += $read->qtde;

                $conta_ent[$read->valor] += (float)(($read->qtde/6) * $read->valor);
                $conta_entra += (float)(($read->qtde/6) * $read->valor);

                $conta_sai[$read->valor] += (float)($read->linha+$read->bingo+$read->bingo2+$read->extra);
                $conta_saida += (float)($read->linha+$read->bingo+$read->bingo2+$read->extra);
                $conta_linha += $read->linha;
                $conta_bingo += $read->bingo;
                $conta_bingo2 += $read->bingo2;
                $conta_extra += $read->extra;

                $conta_cor[0] += $read->cortesia;
                $conta_cor[1] += ($read->cortesia/6)*$read->valor;
            }

            // Recupera Lançamentos
            $repository = new TRepository('movimento');
            $criteria = new TCriteria;
            $criteria->setProperty('order', 'maquina asc, descricao asc, fechado asc');
            $criteria->add(new TFilter('fechado', '=', $this->primeirodia));
            $customers = $repository->load($criteria);

            $this->datagrid0->clear();
            $this->datagrid1->clear();
            $this->datagrid2->clear();
            $this->datagrid3->clear();
            $this->datagrid4->clear();

            $sangria=0;
            $pagamentos=0;
            $inicial=0;
            $reforco=0;
            $aporte=0;
            $pagos=0;
            $dinheiro=0;
            $retirada=0;
            $cartao1=0;
            $cartao2=0;
            $cheque=0;
            $dolar=0;
            $despesas=0;
            $vales=0;
            $conta=1;
            $a_reforco=array();
            $a_aporte=array();
            $a_vales=array();
            $a_retiradas=array();
            $saldo_vales = 0;
            if ($customers) {
                foreach ($customers as $customer) {
                    if ($customer->maquina < 100) {
                        $pagamentos += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 101) {
                        $inicial += $customer->valor;
                    } elseif ($customer->maquina == 102) {
                        $a_reforco[$conta] = new stdclass();
                        $a_reforco[$conta]->maquinas = $customer->descricao;
                        $a_reforco[$conta]->contadores = $customer->valor;
                        $conta++;
                        $reforco += $customer->valor;
                    } elseif ($customer->maquina == 120) {
                        $a_aporte[$conta] = new stdclass();
                        $a_aporte[$conta]->maquinas = $customer->descricao;
                        $a_aporte[$conta]->contadores = $customer->valor;
                        $conta++;
                        $aporte += $customer->valor;
                    } elseif ($customer->maquina == 150) {
                        $a_retiradas[$conta] = new stdclass();
                        $a_retiradas[$conta]->maquinas = $customer->descricao;
                        $a_retiradas[$conta]->contadores = $customer->valor;
                        $conta++;
                        $retirada -= $customer->valor;
                    } elseif ($customer->maquina == 151) {
                        $cartao1 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 152) {
                        $cartao2 += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 153) {
                        $cheque += ($customer->valor) * -1;
                    } elseif ($customer->maquina == 500) {
                        $saldo_vales += ($customer->valor);
                    } elseif ($customer->maquina == 158 or $customer->maquina == 103) {
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid3->addItem($obj);
                        $vales += $customer->valor;
                    } elseif ($customer->maquina < 400){
                        $obj = new stdclass();
                        $obj->maquinas = $customer->descricao;
                        $obj->contadores = $customer->valor;
                        $this->datagrid4->addItem($obj);
                        $despesas += $customer->valor;
                    }
                    if ($customer->maquina < 400) {
                        $dinheiro += $customer->valor;
                    }
                }
            }

            $saldo_clientes = $saldo_vales + ($vales * -1);

            $geral = $inicial+$reforco+$aporte+($conta_entra - $conta_saida)+$saldo_vales;

            for ($i = 0; $i <= 100; $i++) {
                if($conta_card[$i] != 0){
                    $obj = new stdclass();
                    $obj->maquinas   = 'SÉRIE DE '.number_format($i, 2, ',', '.').' - '.$conta_card[$i].' CARTÕES VENDIDOS';
                    $obj->contadores = $conta_ent[$i];
                    $this->datagrid0->addItem($obj);
                }
            }
            $obj = new stdclass();
            $obj->maquinas   = array_sum($conta_card).' CARTÕES VENDIDOS - ARRECADADO';
            $obj->contadores = $conta_entra;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'LINHAS PAGAS';
            $obj->contadores = $conta_linha * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'BINGOS PAGOS';
            $obj->contadores = $conta_bingo * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = '2º BINGOS PAGOS';
            $obj->contadores = $conta_bingo2 * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'PRÊMIOS EXTRAS';
            $obj->contadores = $conta_extra * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL DE PRÊMIOS';
            $obj->contadores = $conta_saida * -1;
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'RESULTADO';
            $obj->contadores = $conta_entra - array_sum($conta_sai);
            $this->datagrid0->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas   = 'CAIXA INICIAL';
            $obj->contadores = $inicial;
            $this->datagrid0->addItem($obj);

//            $obj = new stdclass();
//            $obj->maquinas   = 'SALDO DE VALES ANTERIOR';
//            $obj->contadores = $saldo_vales;
//            $this->datagrid1->addItem($obj);
            if($reforco != 0) {
                foreach ($a_reforco as $key =>$item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_reforco[$key]->maquinas;
                    $obj->contadores = $a_reforco[$key]->contadores;
                    $this->datagrid0->addItem($obj);
                }
            }
            if($aporte != 0) {
                foreach ($a_aporte as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_aporte[$key]->maquinas;
                    $obj->contadores = $a_aporte[$key]->contadores;
                    $this->datagrid0->addItem($obj);
                }
            }
//            $obj = new stdclass();
//            $obj->maquinas = 'SALDO DE CAIXA';
//            $obj->contadores = $conta_entra - array_sum($conta_sai);
//            $this->datagrid1->addItem($obj);
            $obj = new stdclass();
            $obj->maquinas   = 'TOTAL';
            $obj->contadores = $geral;
            $this->datagrid0->addItem($obj);

            $dinheiro =  $geral + $despesas - $cartao1 -  $cartao2 - $cheque - $retirada - $saldo_clientes;

            $obj = new stdclass();
           $obj->maquinas   = 'DINHEIRO';
            $obj->contadores = $dinheiro;
            $this->datagrid2->addItem($obj);
            if($cartao1 != 0) {
                $codigo = new codigo(151);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cartao1;
                $this->datagrid2->addItem($obj);
            }
            if($cheque != 0) {
                $codigo = new codigo(153);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cheque;
                $this->datagrid2->addItem($obj);
            }

//            $obj = new stdclass();
//            $obj->maquinas   = 'VALES';
//            $obj->contadores = ($saldo_clientes - $saldo_vales);
//            $this->datagrid2->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'DESPESAS';
            $obj->contadores = $despesas*-1;
            $this->datagrid2->addItem($obj);

            if($retirada != 0) {
                foreach ($a_retiradas as $key => $item){
                    $obj = new stdclass();
                    $obj->maquinas = $a_retiradas[$key]->maquinas;
                    $obj->contadores = $a_retiradas[$key]->contadores * -1;
                    $this->datagrid2->addItem($obj);
                }
            }
            if($cartao2 != 0) {
                $codigo = new codigo(152);
                $obj = new stdclass();
                $obj->maquinas = $codigo->descricao;
                $obj->contadores = $cartao2;
                $this->datagrid2->addItem($obj);
            }
/*
            $obj = new stdclass();
            $situacao = ($dinheiro+$cartao1+$cartao2+$cheque+$saldo_clientes-$saldo_vales-$despesas+$retirada) - $geral  ;
            if($situacao > 0){$obj->maquinas = 'FALTA DE CAIXA';}else{$obj->maquinas = 'SOBRA DE CAIXA';}
            $obj->contadores = $situacao * -1;
            $this->datagrid2->addItem($obj);
*/
            $obj = new stdclass();
            $obj->maquinas = 'CAIXA';
            $obj->contadores = $dinheiro + $cartao1 + $cartao2 + $cheque + $saldo_clientes - $saldo_vales - $despesas + $retirada;
            $this->datagrid2->addItem($obj);

//            $obj = new stdclass();
//            $obj->maquinas = 'TOTAL';
//            $obj->contadores = $vales;
//            $this->datagrid3->addItem($obj);

//            $obj = new stdclass();
//            $obj->maquinas   = 'SALDO DE VALES ATUAL';
//            $obj->contadores = $saldo_clientes;
//            $this->datagrid3->addItem($obj);

            $obj = new stdclass();
            $obj->maquinas = 'TOTAL';
            $obj->contadores = $despesas;
            $this->datagrid4->addItem($obj);

            $lab_cxdia = new TLabel('dia');
            $lab_cxdia->setFontSize(17);
            $lab_cxdia->setFontFace('Trebuchet MS');
            $lab_cxdia->setValue('CAIXA DO DIA - ');
            $this->frame->add($lab_cxdia);

            $lab_dia = new TLabel('dia');
            $lab_dia->setFontSize(17);
            $lab_dia->setFontFace('Trebuchet MS');
            $form_dia = substr($this->primeirodia,8,2).'/'.substr($this->primeirodia,5,2).'/'.substr($this->primeirodia,0,4);
            $lab_dia->setValue($form_dia);
            $this->frame->add($lab_dia);

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
            $this->CxInicial = $dinheiro;

        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

    /**
     * Format saldo
     */
    public function formatSaldo($stock, $object, $row)
    {

        $number = number_format($stock, 2, ',', '.');
//        if($object->maquinas =='TOTAL DE ENTRADAS'){$row->style = "background: #00BFFF";}
//        if($object->maquinas =='TOTAL DE PAGAMENTOS'){$row->style = "background: #FF3030";}
        $row->style = "background: #C1CDC1";
        if ($object->maquinas == 'CAIXA') {
            $row->style = "background: #00F5FF";
        }
        if($object->maquinas =='SALDO'){$row->style = "background: #00F5FF";}
        if($object->maquinas =='TOTAL'){$row->style = "background: #00F5FF";}
        if(strpos($object->maquinas,'DE PR')){$row->style = "background: #90EE90";}
        if(strpos($object->maquinas,'ARRECADADO')){$row->style = "background: #90EE90";}
        if(strpos($object->maquinas,'ATUAL')){$row->style = "background: #90EE90";}

        if ($stock < 0)
        {
            return "<span style='color:red'>$number</span>";
        }
        else
        {
            return "<span style='color:blue'>$number</span>";
        }
    }
}